#
############################################################
# MODULE:    Multiple-use sgmlspl package
# VERSION:   1.0
# DATE:      November 17, 1997
#
# MULBERRY INTERNAL VERSION CONTROL:
# $Id: taglib.dtd,v 1.2.1.1 1997/07/30 20:04:30 tkg Exp $
############################################################

############################################################
# SYSTEM:    This is a general-purpose package
#
# PURPOSE:   This is an object-oriented implementation of
#            David Megginson's sgmlspl.pl that allows multiple
#            instances of input ESIS streams
#
# CONTAINS:  1) "Package-ized" version of sgmlspl.pl handler handling
#
# PACKAGES REQUIRED:
#            1) David Megginson's SGMLS package
#            2) Carp
#
# ORIGINAL CREATION DATE:
#            November 1997
#
# CREATED BY:
#            Mulberry Technologies, Inc.
#            17 West Jefferson Street, Suite 207
#            Rockville, MD  20850
#            Phone:  301/315-9631
#            Fax:    301/315-8285
#            e-mail: info@mulberrytech.com
#            WWW:    http://www.mulberrytech.com
############################################################

############################################################
# Object-oriented (or at least "decoupled from STDIN") version
# of sgmlspl.pl
package SGMLSPL;
use SGMLS;
use Carp;
				# Constructor.
sub new {
    my ($class) = shift;
    return bless [
		  sub {},
                  sub {},
                  { '' => sub {} },
                  { '' => sub {} },
                  sub { main::output($_[0]); },
                  { '' => sub { main::output($_[0]);} },
                  sub { main::output("\n"); },
                  sub { '' => sub {} },
                  { '' => sub {} },
                  { '' => sub {} },
                  { '' => sub {} },
                  sub {}
 		  ];
}
				# Accessors.
sub start_document_handler { return $_[0]->[0]; }
sub end_document_handler { return $_[0]->[1]; }
sub start_element_handlers { return $_[0]->[2]; }
sub end_element_handlers { return $_[0]->[3]; }
sub cdata_handler { return $_[0]->[4]; }
sub sdata_handlers { return $_[0]->[5]; }
sub re_handler { return $_[0]->[6]; }
sub pi_handler { return $_[0]->[7]; }
sub entity_handlers { return $_[0]->[8]; }
sub start_subdoc_handlers { return $_[0]->[9]; }
sub end_subdoc_handlers { return $_[0]->[10]; }
sub conforming_handler { return $_[0]->[11]; }

				# Generate a key for the event.
sub key {
    my $self = shift;
    if (ref($self->data) eq SGMLS_Element ||
	ref($self->data) eq SGMLS_Entity) {
	return $self->data->name;
    } else {
	return $self->data;
    }
}
				# Look up an entity in the parse.
sub entity {
    my ($self,$ename) = (@_);
    return $self->parse->entity($ename);
}
				# Look up a notation in the parse.
sub notation {
    my ($self,$nname) = (@_);
    return $self->parse->notation($nname);
}
    
sub sgml {
    my ($pSelf, $spec,$handler) = (@_);

#    print "$pSelf:$spec:$handler:\n";

    if (ref($handler) ne 'CODE') {
	$handler =~ s/\\/\\\\/g;
	$handler =~ s/'/\\'/g;
	if ($handler eq '') {
	    $handler = sub {};
	} else {
	    $handler = eval "sub { main::output('$handler'); };";
	}
    }
  SWITCH: {
				# start-document handler
      $spec eq 'start' && do {
	  $pSelf->[0] = $handler;
	  last SWITCH;
      };
				# end-document handler
      $spec eq 'end' && do {
	  $pSelf->[1] = $handler;
	  last SWITCH;
      };
				# start-element handler
      $spec =~ /^<([^\/].*|)>$/ && do {
	  $pSelf->[2]->{$1} = $handler;
	  last SWITCH;
      };
				# generic start-element handler
      $spec eq 'start_element' && do {
	  $pSelf->[2]->{''} = $handler;
	  last SWITCH;
      };
				# end-element handler
      $spec =~ /^<\/(.*)>$/ && do {
	  $pSelf->[3]->{$1} = $handler;
	  last SWITCH;
      };
				# generic end-element handler
      $spec =~ 'end_element' && do {
	  $pSelf->[3]->{''} = $handler;
	  last SWITCH;
      };
				# cdata handler
      $spec eq 'cdata' && do {
	  $pSelf->[4] = $handler;
	  last SWITCH;
      };
				# sdata handler
      $spec =~ /^\|(.*)\|$/ && do {
	  $pSelf->[5]->{$1} = $handler;
	  last SWITCH;
      };
				# generic sdata handler
      $spec eq 'sdata' && do {
	  $pSelf->[5]->{''} = $handler;
	  last SWITCH;
      };
				# record-end handler
      $spec eq 're' && do {
	  $pSelf->[6] = $handler;
	  last SWITCH;
      };
				# processing-instruction handler
      $spec eq 'pi' && do {
	  $pSelf->[7] = $handler;
	  last SWITCH;
      };
				# entity-reference handler
      $spec =~ /^\&(.*);$/ && do {
	  $pSelf->[8]->{$1} = $handler;
	  last SWITCH;
      };
				# generic entity-reference handler
      $spec eq 'entity' && do {
	  $pSelf->[8]->{''} = $handler;
	  last SWITCH;
      };
				# start-subdoc handler
      $spec =~ /^\{([^\/].*|)\}$/ && do {
	  $pSelf->[9]->{$1} = $handler;
	  last SWITCH;
      };
				# generic start-subdoc handler
      $spec eq 'start_subdoc' && do {
	  $pSelf->[9]->{''} = $handler;
	  last SWITCH;
      };
				# end-subdoc handler
      $spec =~ /^\{\/(.*)\}$/ && do {
	  $pSelf->[10]->{$1} = $handler;
	  last SWITCH;
      };
				# generic end-subdoc handler
      $spec eq 'end_subdoc' && do {
	  $pSelf->[10]->{''} = $handler;
	  last SWITCH;
      };
				# conforming handler
      $spec eq 'conforming' && do {
	  $pSelf->[11] = $handler;
	  last SWITCH;
      };

      die "Bad SGML handler pattern: $spec\n";
  }
}

sub Process {
    my ($pSelf, $pFileHandle) = (@_);

    $parse = new SGMLS("main::$pFileHandle");	# a new parse object

#    print "$pSelf:$pFileHandle:$parse:\n";
    &{$pSelf->[0]}();	# run the start handler.

				# run the appropriate handler for each
				# event
    while ($event = $parse->next_event) {
	my $type = $event->type;
      SWITCH: {
	  $type eq 'start_element' && do {
	      &{($pSelf->[2]->{$event->data->name}||
		 $pSelf->[2]->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'end_element' && do {
	      &{($pSelf->end_element_handlers->{$event->data->name}||
		 $pSelf->end_element_handlers->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'cdata' && do {
	      &{$pSelf->cdata_handler}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'sdata' && do {
	      &{($pSelf->sdata_handlers->{$event->data}||
		 $pSelf->sdata_handlers->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 're' && do {
	      &{$pSelf->re_handler}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'pi' && do {
	      &{$pSelf->pi_handler}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'entity' && do {
	      &{($pSelf->entity_handlers->{$event->data->name}||
		 $pSelf->entity_handlers->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'start_subdoc' && do {
	      &{($pSelf->start_subdoc_handlers->{$event->data->name}||
		 $pSelf->start_subdoc_handlers->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'end_subdoc' && do {
	      &{($pSelf->end_subdoc_handlers->{$event->data->name}||
		 $pSelf->end_subdoc_handlers->{''} || sub {})}($event->data,$event);
	      last SWITCH;
	  };
	  $type eq 'conforming' && do {
	      &{$pSelf->conforming_handler}($event->data,$event);
	      last SWITCH;
	  };

	  die "Unknown SGML event type: $type\n";
      }
    }

    &{$pSelf->end_document_handler}();	# run the end handler
}

############################################################

1;
